%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      CreateSensorGauss_5New.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% Description:    This file defines a custom image sensor array
%-------------------------------------------------------------------------------

if ieNotDefined('SavePlots'), SavePlots = false ; end

% Check if the settings are defined, otherwise go to defaults
if ieNotDefined('numSensors'), numSensors = 3 ; end
if ieNotDefined('sensorPos')
    % Separate the filters linearly across the spectrum
    sensorPos = linspace(minWavelength,maxWavelength,numSensors);
end
if ieNotDefined('sensorWidth')
    sensorWidth = ones(size(sensorPos))*(sensorPos(2)-sensorPos(1))/2;
end
if ieNotDefined('sensorAmp'), sensorAmp = ones(size(sensorPos)) ; end

% Build a default sensor
sensor = sensorCreate;
wave = sceneGet(scene,'wave');

cfType = 'gaussian'; 
filterSpectra = sensorColorFilter(cfType, wave, sensorPos, sensorWidth);

% Use some subset of these names
allNames = {'b1','g1','r1','x1','i1','z1','i2'};
filterNames = cell(1,numSensors);
for ii=1:numSensors, 
   filterNames{ii} = allNames{ii};
   %filterNames{ii} = [num2str(uint16(cPos(ii))) 'nm'];
end

% Show the wavelength partitioning
figure(1); 
plot(wave,filterSpectra,'Linewidth',2)
title([num2str(numSensors) '-color sensor #' num2str(sensorIndex) ' filters']);
xlabel('Wavelength [nm]');
ylabel('Transmittance');
grid on;

if(SavePlots)
    saveas(gcf, ['./Images/ColorFilters' num2str(numSensors) 'colors_sensor' num2str(sensorIndex) '.eps'],'epsc2');
    saveas(gcf, ['./Images/ColorFilters' num2str(numSensors) 'colors_sensor' num2str(sensorIndex) '.png']);
end

sensor = sensorSet(sensor,'wave',wave);
sensor = sensorSet(sensor,'filterSpectra',filterSpectra);
sensor = sensorSet(sensor,'filterNames',filterNames);


% Define the pattern for the sensor
p = [];
switch numSensors
    case {3}
        p = [3,2;2,1];
    case {4}
        p = [1,2;3,4];
    case {5}
        p = [1,2,3; 2,3,4; 3,4,5];
    case {6}
        p = [1,3,4; 5,4,2; 4,3,6];
    case {7}
        p = [1,3,4; 2,4,6; 4,5,7];
    otherwise
        p = [];
      while length(unique(p(:))) ~= numSensors
          p = round(rand(3,3)*(numSensors-1) + 1);
      end
      fprintf('Spatial pattern\n')
      p
end

sensor = sensorSet(sensor,'pattern',p);

if (showISET == TRUE),
   sensorShowCFA(sensor);
end

% Match the sensor size to the scene FOV
sensor = sensorSetSizeToFOV(sensor,sceneGet(scene,'fov'));

% Compute the image and bring it up.
sensor = sensorCompute(sensor,oi);

if (showISET == TRUE),
   sensorImageWindow;
   vcAddAndSelectObject(sensor);
else
   if ieNotDefined('sensor'),
        vcAddAndSelectObject(sensor);
   else 
        vcReplaceAndSelectObject(sensor);
   end
end

% End of File
